using UnityEngine;
using System;
using System.Collections;
using System.Collections.Generic;
using Newtonsoft.Json;

namespace quicksdk
{
    // LoginKitLisener
    public abstract class LoginKitListener : MonoBehaviour
    {
        //callback
		public abstract void onInitSuccess(string msg);
        public abstract void onLoginSuccess(string userInfo);
		public abstract void onBindSuccess(string userInfo);
		public abstract void onUnBindSuccess(string userInfo);
        public abstract void onGameLogoutSuccess(string msg);
        public abstract void onLogoutSuccess(string msg);
        public abstract void onPurchaseSuccess(string orderInfos);
        public abstract void onPurchaseFail();
        public abstract void onRestoreSuccess(string products);
        public abstract void onRestoreFail(string message);
        public abstract void findProductInfoSuccess(string products);
        public abstract void findProductInfoFail(string message);
        //callback end


		public void onInitSuccess(string msg)
		{
          //执行初始化成功操作
		}
        public void onLoginSuccess(string userInfo)
        {
            var data = SimpleJSON.JSONNode.Parse(userInfo);
            string uid = data["uid"].Value;
            string token = data["token"].Value;
            string loginType = data["loginType"].Value;
            string isNewUser = data[@"isNewUser"].Value;
            string isGuest = data[@"isGuest"].Value;
          //执行登录成功操作
        }
        public void onBindSuccess(string userInfo)
        {
            var data = SimpleJSON.JSONNode.Parse(userInfo);
            string uid = data["uid"].Value;
            string token = data["token"].Value;
            string type = data["type"].Value;
          //执行绑定成功操作
        }
        public void onUnBindSuccess(string userInfo)
        {
            var data = SimpleJSON.JSONNode.Parse(userInfo);
            string uid = data["uid"].Value;
            string token = data["token"].Value;
            string type = data["type"].Value;
          //执行解绑成功操作
        }
        public void onGameLogoutSuccess(string msg)
        {
          //游戏主动调用logout操作完成回调
        }
        public void onLogoutSuccess(string msg)
        {
          //玩家主动点击个人中心切换账号成功回调
        }
        public void onPurchaseSuccess(string orderInfos)
        {
            var data = SimpleJSON.JSONNode.Parse(orderInfos);
            string productId = data["productId"].Value;
            string orderNo = data["orderNo"].Value;
            //gameOrderNo可能为空字符串比如订阅品续订时
            string gameOrderNo = data["gameOrderNo"].Value;
            string receiptString = data["receiptString"].Value;
          //购买成功回调
        }
        public void onPurchaseFail()
        {
          //购买失败回调
        }
        public void onRestoreSuccess(string products)
        {
            var data = SimpleJSON.JSONNode.Parse(products);
          //恢复Appstore订阅品购买成功回调
        }
        public void onRestoreFail(string msg)
        {
          //恢复Appstore订阅品购买失败回调
        }
        public void findProductInfoSuccess(string products)
        {
            var listdata = SimpleJSON.JSONNode.Parse(products);
            var data = listdata[0];
            string productId = data["productId"].Value;
            string productName = data["productName"].Value;
            string productDesc = data["productDesc"].Value;
            string price = data["price"].Value;
            string total = data["total"].Value;
            string extras_params = data["extras_params"].Value;
          //从苹果服务器获取商品信息成功回调
        }
        public void findProductInfoFail(string msg)
        {
          //从苹果服务器获取商品信息失败回调
        }
    }
}
